///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _SQLIMPORT_H
#define _SQLIMPORT_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../CSockSrvr/CSockSrvr.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _SQLImportMembers{
    char **ColumnNames;
    char **SingleRowData;

	int *iOutDataType;
    int *iOutColumnSize;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowDataColumns(struct _SQLImportMembers *SIM, int ColumnCount);
void FreeColumnNames(struct _SQLImportMembers *SIM, int ColumnCount);
void FreeSingleRowData(struct _SQLImportMembers *SIM);
bool ImportSQLResults(CSockSrvr *pSockSrvr, int iClient, int *iOutID, bool bCheckExistance, char *InFileName);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
